/**************************************************************************************************
 * Header file for Packet Handler application.
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
***************************************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
***********************************************************************************************//*!
**************************************************************************************************/

#ifndef PACKETHANDLER_H_
#define PACKETHANDLER_H_

extern void PacketHandler(void);
extern void PacketHandlerUartRxCallback(uint8_t *ptrUartRxData);
extern void PacketHandler_InitVariables(void);
extern void PacketHandler_MCPSDataConfirm(void);
extern void PacketHandler_MCPSDataIndication(void);

#define gPreambleSize_c 					( 0x5A )
#define gSyncWordSize_c 					( 0xD1 )
#define gSyncWordValue_c 					( 0xDC )
#define gPayloadLength_c 					( 0xD4 )
#define gDestinationAddress_c				( 0xD5 )
#define gNumOfPckt_c  			        	( 0xD6 )
#define gCrc_c 					            ( 0xD8 )
#define gCrcAutoclear_c 					( 0xD9 )
#define gTxStart_c         					( 0xDA )
#define gTxStop_c							( 0xDE )
#define gTxAck_c							( 0xC3 )
#define gTxEnd_c							( 0x5B )
#define gRxStart_c         					( 0xDF )
#define gRxStop_c         					( 0xD3 )
#define gRxAck_c         					( 0xC7 )
#define gRxEnd_c         					( 0xC6 )
#define gPacketConfig_c    					( 0xD2 )
#define gInterPacketRxDelay_c				( 0xD7 )
#define gPrbs9Test_c						( 0xE7 )
#define gPrbs9StopTest_c					( 0xE8 )

#define gDefaultPreambleLength_c			( 3 )
#define gDefaultSyncWordSize_c				( 4 )
#define gPrbs9BufferLength_c				( 65 )

#endif /* PACKETHANDLER_H_ */
